/*
	File: CEG_JIP.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to ensure the MP clients joining in progress (JIP) have the correct public variable values for different aspects of the CEG Simulation.

	Parameters:
	None.
	
	Execution:
	Executed from CEG_client.sqf.  Will only run on JIP MP clients due to conditions checked in CEG_client.sqf.
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_JIP.sqf: Thread started."] call LGD_fnc_debugMessage;}; //DEBUG

// Scope //
private ["_obj", "_onStr", "_on"];

// Begin a forEach loop to individually update the power on state of CEG objects is correct for JIP players.
{
	
	// Assign local variables to elements extracted from the CEG_objects array in this iteration of the forEach loop.
	_obj = (_x select 0); // "objectName_location".
	_onStr = (format ["CEG_on_%1", _obj]);

	// Get the current "power on" state for this object.
	_on = missionNameSpace getVariable _onStr;
	
	// If the power state is off, then execute CEG_events.sqf and pass the "power on" state of this object to it.
	if (!(_on)) then 
	{
		_nul = [_onStr, _on] execVM "CEG\Scripts\CEG_events.sqf";
	};

	sleep .01;
	
} forEach CEG_objects; // CEG_objects was initialized in CEG_init.sqf.

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_JIP.sqf: Thread finished."] call LGD_fnc_debugMessage;}; //DEBUG